Scriptname RaceMenuPluginPoses extends RaceMenuBase

;Callbacks Table
string Property CALLBACK_POSE_DEFAULT = "ChangePoseVanilla" AutoReadOnly

;;FNIS Spells
string Property CALLBACK_POSE_FNISSPC = "ChangePoseFNISSPc" AutoReadOnly
string Property CALLBACK_POSE_FNISSPA = "ChangePoseFNISSPa" AutoReadOnly
string Property CALLBACK_POSE_FNISSPO = "ChangePoseFNISSPo" AutoReadOnly
string Property CALLBACK_POSE_FNISSPB = "ChangePoseFNISSPb" AutoReadOnly

;;SAM
string Property CALLBACK_POSE_SAM = "ChangePoseSAM" AutoReadOnly

;;Pinup Poser
string Property CALLBACK_POSE_PINUPACTION = "ChangePosePinupAction" AutoReadOnly
string Property CALLBACK_POSE_PINUPDPOSER = "ChangePosePinupDPoser" AutoReadOnly
string Property CALLBACK_POSE_PINUPPAIR = "ChangePosePinupPair" AutoReadOnly
string Property CALLBACK_POSE_PINUPSTAND = "ChangePosePinupStand" AutoReadOnly
string Property CALLBACK_POSE_PINUPKNEEL = "ChangePosePinupKneel" AutoReadOnly
string Property CALLBACK_POSE_PINUPLAY = "ChangePosePinupLay" AutoReadOnly
string Property CALLBACK_POSE_PINUPSIT = "ChangePosePinupSit" AutoReadOnly
string Property CALLBACK_POSE_PINUPEX = "ChangePosePinupEX" AutoReadOnly
string Property CALLBACK_POSE_PINUPMAN = "ChangePosePinupMan" AutoReadOnly
string Property CALLBACK_POSE_SNSD = "ChangePosePinupSNSD" AutoReadOnly

;;Halo Poser
string Property CALLBACK_POSE_HALOPOSER = "ChangePoseHaloPoser" AutoReadOnly
string Property CALLBACK_POSE_HALOPOSERTREESOME = "ChangePoseHaloPoserThreesome" AutoReadOnly
string Property CALLBACK_POSE_HALOPOSEREXT = "ChangePoseHaloPoserEXT" AutoReadOnly
string Property CALLBACK_POSE_HALOPOSERPAIR = "ChangePoseHaloPoserHPPair" AutoReadOnly
string Property CALLBACK_POSE_HALOPOSERPAIR2 = "ChangePoseHaloPoserH2Pair" AutoReadOnly
string Property CALLBACK_POSE_HALOPOSERPAIR3 = "ChangePoseHaloPoserH3Pair" AutoReadOnly
string Property CALLBACK_POSE_HALOPOSERSILLY = "ChangePoseHaloPoserHSP" AutoReadOnly
string Property CALLBACK_POSE_HALOPOSEROBJECT = "ChangePoseHaloPoserHObP" AutoReadOnly

;;Public Poser
string Property CALLBACK_POSE_PUBLICPOSER1 = "ChangePosePinupPublic1" AutoReadOnly
string Property CALLBACK_POSE_PUBLICPOSER2 = "ChangePosePinupPublic2" AutoReadOnly
string Property CALLBACK_POSE_PUBLICPOSER3 = "ChangePosePinupPublic3" AutoReadOnly
string Property CALLBACK_POSE_PUBLICPOSER4 = "ChangePosePinupPublic4" AutoReadOnly
string Property CALLBACK_POSE_PUBLICPOSER5 = "ChangePosePinupPublic5" AutoReadOnly

;;Pinup Poser MCM
string Property CALLBACK_POSE_PINUPACTIONMCM = "ChangePosePinupActionMCM" AutoReadOnly
string Property CALLBACK_POSE_PINUPKNEELMCM = "ChangePosePinupKneelMCM" AutoReadOnly
string Property CALLBACK_POSE_PINUPLAYMCM = "ChangePosePinupLayMCM" AutoReadOnly
string Property CALLBACK_POSE_PINUPMANMCM = "ChangePosePinupManMCM" AutoReadOnly
string Property CALLBACK_POSE_PINUPOTHERMCM = "ChangePosePinupOtherMCM" AutoReadOnly
string Property CALLBACK_POSE_PINUPPAIRMCM = "ChangePosePinupPairMCM" AutoReadOnly
string Property CALLBACK_POSE_PINUPSITMCM = "ChangePosePinupSitMCM" AutoReadOnly
string Property CALLBACK_POSE_PINUPSTANDMCM = "ChangePosePinupStandMCM" AutoReadOnly

;;Halo Poser MCM
string Property CALLBACK_POSE_HALOHPCOMCM = "ChangePoseHaloPoserCustomOneMCM" AutoReadOnly
string Property CALLBACK_POSE_HALOHPCTMCM = "ChangePoseHaloPoserCustomTwoMCM" AutoReadOnly
string Property CALLBACK_POSE_HALOHPCTRMCM = "ChangePoseHaloPoserCustomThreeMCM" AutoReadOnly
string Property CALLBACK_POSE_HALOHPEXMCM = "ChangePoseHaloPoserExMCM" AutoReadOnly
string Property CALLBACK_POSE_HALOHPOMCM = "ChangePoseHaloPoserObjectMCM" AutoReadOnly
string Property CALLBACK_POSE_HALOHPPMCM = "ChangePoseHaloPoserPairMCM" AutoReadOnly
string Property CALLBACK_POSE_HALOHPSMCM = "ChangePoseHaloPoserSillyMCM" AutoReadOnly
string Property CALLBACK_POSE_HALOHPTMCM = "ChangePoseHaloPoserThreesomeMCM" AutoReadOnly
string Property CALLBACK_POSE_HALOHPWMCM = "ChangePoseHaloPoserWeaponMCM" AutoReadOnly

;;Aloe
string Property CALLBACK_POSE_ALOE = "ChangePoseAloe" AutoReadOnly

;;GomaPeroPero
string Property CALLBACK_POSE_GOMAPEROPERO = "ChangePoseGomaPeroPero" AutoReadOnly

;;Kinoko
string Property CALLBACK_POSE_KINOKO = "ChangePoseKinoko" AutoReadOnly

;;Lamir
string Property CALLBACK_POSE_LAMIR = "ChangePoseLamir" AutoReadOnly

;;EIS Brainsperm
string Property CALLBACK_POSE_BRAINSPERM1 = "ChangePoseBrainsperm1" AutoReadOnly
string Property CALLBACK_POSE_BRAINSPERM2 = "ChangePoseBrainsperm2" AutoReadOnly
string Property CALLBACK_POSE_BRAINSPERM3 = "ChangePoseBrainsperm3" AutoReadOnly
string Property CALLBACK_POSE_BRAINSPERM4 = "ChangePoseBrainsperm4" AutoReadOnly

;;EIS Oden
string Property CALLBACK_POSE_ODEN1 = "ChangePoseOden1" AutoReadOnly
string Property CALLBACK_POSE_ODEN2 = "ChangePoseOden2" AutoReadOnly
string Property CALLBACK_POSE_ODEN3 = "ChangePoseOden3" AutoReadOnly

;;SHOCKY
string Property CALLBACK_POSE_SHOCKY1 = "ChangePoseShocky1" AutoReadOnly
string Property CALLBACK_POSE_SHOCKY2 = "ChangePoseShocky2" AutoReadOnly


;Animation SubString

;;FNIS Spells
string Property POSE_FNISSPC = "FNISSPc" AutoReadOnly
string Property POSE_FNISSPA = "FNISSPa" AutoReadOnly
string Property POSE_FNISSPO = "FNISSPo" AutoReadOnly
string Property POSE_FNISSPB = "FNISSPb" AutoReadOnly

;;SAM
string Property POSE_SAM = "SAMPose" AutoReadOnly

;;Pinup Poser
string Property POSE_PINUPDPOSER = "DPose" AutoReadOnly
string Property POSE_PINUPPAIR = "PPair" AutoReadOnly
string Property POSE_PINUPSTAND = "PUPStand" AutoReadOnly
string Property POSE_PINUPSTAND2 = "PUP2Stand" AutoReadOnly
string Property POSE_PINUPSTAND4 = "PUP4Stand" AutoReadOnly
string Property POSE_PINUPKNEEL = "PUP3Kneel" AutoReadOnly
string Property POSE_PINUPLAY = "PUP3Lay" AutoReadOnly
string Property POSE_PINUPSIT = "PUP3Sit" AutoReadOnly
string Property POSE_PINUPKNEEL5 = "PUP5Kneel" AutoReadOnly
string Property POSE_PINUPLAY5 = "PUP5Lay" AutoReadOnly
string Property POSE_PINUPSIT5 = "PUP5Sit" AutoReadOnly
string Property POSE_PINUPEX = "PUPEX" AutoReadOnly
string Property POSE_PINUPSTANDEX5 = "PPEX5St" AutoReadOnly
string Property POSE_PINUPSITEX5 = "PPEX5Sit" AutoReadOnly
string Property POSE_PINUPKNEELEX5 = "PPEX5Lay" AutoReadOnly
string Property POSE_PINUPLAYEX5 = "PPEX5Kn" AutoReadOnly
string Property POSE_PINUPSTANDEX5W = "PPEX5WSt" AutoReadOnly
string Property POSE_PINUPSITEX5W = "PPEX5WSit" AutoReadOnly
string Property POSE_PINUPKNEELEX5W = "PPEX5WLay" AutoReadOnly
string Property POSE_PINUPLAYEX5W = "PPEX5WKn" AutoReadOnly
string Property POSE_PINUPMANSTAND = "PUPMStand" AutoReadOnly
string Property POSE_PINUPMANSIT = "PUPMSit" AutoReadOnly
string Property POSE_PINUPMANLAY = "PUPMLay" AutoReadOnly
string Property POSE_PINUPMANKNEEL = "PUPMKneel" AutoReadOnly
string Property POSE_SNSDGEE = "Gee" AutoReadOnly
string Property POSE_SNSDOH = "Oh" AutoReadOnly
string Property POSE_SNSDRDR = "RDR" AutoReadOnly
string Property POSE_SNSDBG = "BG" AutoReadOnly
string Property POSE_SNSDHOOT = "Hoot" AutoReadOnly
string Property POSE_SNSDGENIE = "Genie" AutoReadOnly
string Property POSE_SNSDMT = "MT" AutoReadOnly
string Property POSE_SNSDTB = "TB" AutoReadOnly
string Property POSE_SNSDCONCERT = "Concert" AutoReadOnly

;;Halo Poser
string Property POSE_PINUPACTION1HSWORD = "APose1HSword" AutoReadOnly
string Property POSE_PINUPACTIONFIST = "APoseFist" AutoReadOnly
string Property POSE_PINUPACTIONZWEI = "APoseZwei" AutoReadOnly
string Property POSE_PINUPACTIONDUAL = "APoseDual" AutoReadOnly
string Property POSE_PINUPACTIONBOW = "APoseBow" AutoReadOnly
string Property POSE_PINUPACTIONCBOW = "APoseCBow" AutoReadOnly
string Property POSE_HALOPOSER = "CST" AutoReadOnly
string Property POSE_HALOPOSER2 = "CUS" AutoReadOnly
string Property POSE_HALOPOSER3 = "CUT" AutoReadOnly
string Property POSE_HALOPOSER4 = "CSM" AutoReadOnly
string Property POSE_HALOPOSER5 = "CSS" AutoReadOnly
string Property POSE_HALOPOSER6 = "H6P" AutoReadOnly
string Property POSE_HALOPOSER7 = "H7P" AutoReadOnly
string Property POSE_HALOPOSER8 = "H8P" AutoReadOnly
string Property POSE_HALOPOSER9 = "H9P" AutoReadOnly
string Property POSE_HALOPOSER10 = "H10P" AutoReadOnly
string Property POSE_HALOPOSER11 = "H11P" AutoReadOnly
string Property POSE_HALOPOSER12 = "H12P" AutoReadOnly
string Property POSE_HALOPOSER13 = "H13P" AutoReadOnly
string Property POSE_HALOPOSER14 = "H14P" AutoReadOnly
string Property POSE_HALOPOSER15 = "H15P" AutoReadOnly
string Property POSE_HALOPOSERTREESOME = "HPThree" AutoReadOnly
string Property POSE_HALOPOSEREXT = "EXT" AutoReadOnly
string Property POSE_HALOPOSERPAIR = "HPPair" AutoReadOnly
string Property POSE_HALOPOSERPAIR2 = "H2Pair" AutoReadOnly
string Property POSE_HALOPOSERPAIR3 = "H3PP" AutoReadOnly
string Property POSE_HALOPOSERSILLY = "HSP" AutoReadOnly
string Property POSE_HALOPOSEROBJECT = "HObP" AutoReadOnly

;;Public Poser
string Property POSE_PUBLICPOSER1 = "1PUB" AutoReadOnly
string Property POSE_PUBLICPOSER2 = "2PUB" AutoReadOnly
string Property POSE_PUBLICPOSER3 = "3PUB" AutoReadOnly
string Property POSE_PUBLICPOSER4 = "4PUB" AutoReadOnly
string Property POSE_PUBLICPOSER5 = "5PUB" AutoReadOnly

;;Pinup Poser MCM
string Property POSE_PINUPACTIONMCM = "PinupAction" AutoReadOnly
string Property POSE_PINUPKNEELMCM = "PinupKneel" AutoReadOnly
string Property POSE_PINUPLAYMCM = "PinupLay" AutoReadOnly
string Property POSE_PINUPMANMCM = "PinupMan" AutoReadOnly
string Property POSE_PINUPOTHERMCM = "PinupOther" AutoReadOnly
string Property POSE_PINUPPAIRMCM = "PinupPair" AutoReadOnly
string Property POSE_PINUPSITMCM = "PinupSit" AutoReadOnly
string Property POSE_PINUPSTANDMCM = "PinupStand" AutoReadOnly

;;Halo Poser MCM
string Property POSE_HALOHPCOMCM = "HPCO" AutoReadOnly
string Property POSE_HALOHPCTMCM = "HPCT" AutoReadOnly
string Property POSE_HALOHPCTRMCM = "HPCTR" AutoReadOnly
string Property POSE_HALOHPEXMCM = "HPEX" AutoReadOnly
string Property POSE_HALOHPOMCM = "HPO" AutoReadOnly
string Property POSE_HALOHPPMCM = "HPP" AutoReadOnly
string Property POSE_HALOHPSMCM = "HPS" AutoReadOnly
string Property POSE_HALOHPTMCM = "HPT" AutoReadOnly
string Property POSE_HALOHPWMCM = "HPW" AutoReadOnly

;;Aloe
string Property POSE_ALOE = "ALO" AutoReadOnly

;;GomaPeroPero
string Property POSE_GOMAPEROPERO1 = "1GOM" AutoReadOnly
string Property POSE_GOMAPEROPERO2 = "2GOM" AutoReadOnly
string Property POSE_GOMAPEROPERO3 = "3GOM" AutoReadOnly
string Property POSE_GOMAPEROPERO4 = "4GOM" AutoReadOnly

;;Kinoko
string Property POSE_KINOKO = "aa_cpkp" AutoReadOnly

;;Lamir
string Property POSE_LAMIR = "LP" AutoReadOnly

;;EIS Brainsperm
string Property POSE_BRAINSPERM1 = "FNISSP_brainsperm1_o" AutoReadOnly
string Property POSE_BRAINSPERM2 = "FNISSP_brainsperm2_o" AutoReadOnly
string Property POSE_BRAINSPERM3 = "FNISSP_brainsperm3_o" AutoReadOnly
string Property POSE_BRAINSPERM4 = "FNISSP_brainsperm4_o" AutoReadOnly

;;EIS Oden
string Property POSE_ODEN1 = "FNISSP_oden1_o" AutoReadOnly
string Property POSE_ODEN2 = "FNISSP_oden2_o" AutoReadOnly
string Property POSE_ODEN3 = "FNISSP_oden3_o" AutoReadOnly

;;SHOCKY
string Property POSE_SHOCKY1 = "FNISSP_Shocky1_o" AutoReadOnly
string Property POSE_SHOCKY2 = "Sexpose" AutoReadOnly
string Property POSE_SHOCKY2MISC = "misc" AutoReadOnly


; NiOverride version data
int Property NIOVERRIDE_VERSION = 6 AutoReadOnly
int Property NIOVERRIDE_SCRIPT_VERSION = 6 AutoReadOnly

; Category
string Property CATEGORY_POSES = "rsm_poses" AutoReadOnly

bool _versionValid = false

Event OnCategoryRequest()
	AddCategory(CATEGORY_POSES, "$CATEGORY POSES")
EndEvent

Event OnStartup()
	parent.OnStartup()

	int nioverrideVersion = SKSE.GetPluginVersion("NiOverride")
	int nioverrideScriptVersion = NiOverride.GetScriptVersion()

	; Check NiOverride version, disable most features if this fails
	if nioverrideVersion >= NIOVERRIDE_VERSION && nioverrideScriptVersion >= NIOVERRIDE_SCRIPT_VERSION
		_versionValid = true
	Else
		_versionValid = false
	Endif
EndEvent

; Add Custom sliders here
Event OnSliderRequest(Actor target, ActorBase targetBase, Race actorRace, bool isFemale)
	AddSliderEx("$PosesDefault", CATEGORY_POSES, CALLBACK_POSE_DEFAULT, -1, 0, 1, 0)
		
	;;FNIS Spells
	AddSliderEx("$PosesFNISSPc", CATEGORY_POSES, CALLBACK_POSE_FNISSPC, 0, 45, 1, 0)
	AddSliderEx("$PosesFNISSPa", CATEGORY_POSES, CALLBACK_POSE_FNISSPA, 0, 9, 1, 0)
	AddSliderEx("$PosesFNISSPo", CATEGORY_POSES, CALLBACK_POSE_FNISSPO, 0, 18, 1, 0)
	AddSliderEx("$PosesFNISSPb", CATEGORY_POSES, CALLBACK_POSE_FNISSPB, 0, 8, 1, 0)
	
	;;SAM
	AddSliderEx("$PosesSAM", CATEGORY_POSES, CALLBACK_POSE_SAM, 0, 13, 1, 0)
	
	;;PinupPoser
	AddSliderEx("$PosesPinupAction", CATEGORY_POSES, CALLBACK_POSE_PINUPACTION, 0, 81, 1, 0)
	AddSliderEx("$PosesPinupDPoser", CATEGORY_POSES, CALLBACK_POSE_PINUPDPOSER, 0, 81, 1, 0)
	AddSliderEx("$PosesPinupEX", CATEGORY_POSES, CALLBACK_POSE_PINUPEX, 0, 324, 1, 0)
	AddSliderEx("$PosesPinupKneel", CATEGORY_POSES, CALLBACK_POSE_PINUPKNEEL, 0, 72, 1, 0)
	AddSliderEx("$PosesPinupLay", CATEGORY_POSES, CALLBACK_POSE_PINUPLAY, 0, 72, 1, 0)
	AddSliderEx("$PosesPinupMan", CATEGORY_POSES, CALLBACK_POSE_PINUPMAN, 0, 81, 1, 0)	
	AddSliderEx("$PosesPinupPair", CATEGORY_POSES, CALLBACK_POSE_PINUPPAIR, 0, 80, 1, 0)
	AddSliderEx("$PosesPinupSit", CATEGORY_POSES, CALLBACK_POSE_PINUPSIT, 0, 72, 1, 0)
	AddSliderEx("$PosesPinupSNSD", CATEGORY_POSES, CALLBACK_POSE_SNSD, 0, 81, 1, 0)
	AddSliderEx("$PosesPinupStand", CATEGORY_POSES, CALLBACK_POSE_PINUPSTAND, 0, 270, 1, 0)
	
	;;HaloPoser
	AddSliderEx("$PosesHaloPoserCustom", CATEGORY_POSES, CALLBACK_POSE_HALOPOSER, 0, 1215, 1, 0)
	AddSliderEx("$PosesHaloPoserEXT", CATEGORY_POSES, CALLBACK_POSE_HALOPOSEREXT, 0, 81, 1, 0)	
	AddSliderEx("$PosesHaloPoserObject", CATEGORY_POSES, CALLBACK_POSE_HALOPOSEROBJECT, 0, 81, 1, 0)
	AddSliderEx("$PosesHaloPoserPair", CATEGORY_POSES, CALLBACK_POSE_HALOPOSERPAIR, 0, 81, 1, 0)
	AddSliderEx("$PosesHaloPoserPair2", CATEGORY_POSES, CALLBACK_POSE_HALOPOSERPAIR2, 0, 81, 1, 0)
	AddSliderEx("$PosesHaloPoserPair3", CATEGORY_POSES, CALLBACK_POSE_HALOPOSERPAIR3, 0, 80, 1, 0)
	AddSliderEx("$PosesHaloPoserSilly", CATEGORY_POSES, CALLBACK_POSE_HALOPOSERSILLY, 0, 81, 1, 0)
	AddSliderEx("$PosesHaloPoserThreesome", CATEGORY_POSES, CALLBACK_POSE_HALOPOSERTREESOME, 0, 81, 1, 0)
		
	;;PublicPoser
	AddSliderEx("$PosesPinupPublic1", CATEGORY_POSES, CALLBACK_POSE_PUBLICPOSER1, 0, 81, 1, 0)
	AddSliderEx("$PosesPinupPublic2", CATEGORY_POSES, CALLBACK_POSE_PUBLICPOSER2, 0, 81, 1, 0)
	AddSliderEx("$PosesPinupPublic3", CATEGORY_POSES, CALLBACK_POSE_PUBLICPOSER3, 0, 81, 1, 0)
	AddSliderEx("$PosesPinupPublic4", CATEGORY_POSES, CALLBACK_POSE_PUBLICPOSER4, 0, 81, 1, 0)
	AddSliderEx("$PosesPinupPublic5", CATEGORY_POSES, CALLBACK_POSE_PUBLICPOSER5, 0, 81, 1, 0)
	
	;;PinupPoserMCM	
	AddSliderEx("$PosesPinupActionMCM", CATEGORY_POSES, CALLBACK_POSE_PINUPACTIONMCM, 0, 137, 1, 0)
	AddSliderEx("$PosesPinupKneelMCM", CATEGORY_POSES, CALLBACK_POSE_PINUPKNEELMCM, 0, 74, 1, 0)
	AddSliderEx("$PosesPinupLayMCM", CATEGORY_POSES, CALLBACK_POSE_PINUPLAYMCM, 0, 106, 1, 0)
	AddSliderEx("$PosesPinupManMCM", CATEGORY_POSES, CALLBACK_POSE_PINUPMANMCM, 0, 81, 1, 0)
	AddSliderEx("$PosesPinupOtherMCM", CATEGORY_POSES, CALLBACK_POSE_PINUPOTHERMCM, 0, 94, 1, 0)
	AddSliderEx("$PosesPinupPairMCM", CATEGORY_POSES, CALLBACK_POSE_PINUPPAIRMCM, 0, 126, 1, 0)
	AddSliderEx("$PosesPinupSitMCM", CATEGORY_POSES, CALLBACK_POSE_PINUPSITMCM, 0, 114, 1, 0)	
	AddSliderEx("$PosesPinupStandMCM", CATEGORY_POSES, CALLBACK_POSE_PINUPSTANDMCM, 0, 311, 1, 0)

	;;HaloPoserMCM
	AddSliderEx("$PosesHaloPoserCustomOneMCM", CATEGORY_POSES, CALLBACK_POSE_HALOHPCOMCM, 0, 405, 1, 0)
	AddSliderEx("$PosesHaloPoserCustomTwoMCM", CATEGORY_POSES, CALLBACK_POSE_HALOHPCTMCM, 0, 405, 1, 0)
	AddSliderEx("$PosesHaloPoserCustomThreeMCM", CATEGORY_POSES, CALLBACK_POSE_HALOHPCTRMCM, 0, 324, 1, 0)
	AddSliderEx("$PosesHaloPoserExMCM", CATEGORY_POSES, CALLBACK_POSE_HALOHPEXMCM, 0, 80, 1, 0)
	AddSliderEx("$PosesHaloPoserObjectMCM", CATEGORY_POSES, CALLBACK_POSE_HALOHPOMCM, 0, 65, 1, 0)
	AddSliderEx("$PosesHaloPoserPairMCM", CATEGORY_POSES, CALLBACK_POSE_HALOHPPMCM, 0, 240, 1, 0)
	AddSliderEx("$PosesHaloPoserSillyMCM", CATEGORY_POSES, CALLBACK_POSE_HALOHPSMCM, 0, 9, 1, 0)
	AddSliderEx("$PosesHaloPoserThreesomeMCM", CATEGORY_POSES, CALLBACK_POSE_HALOHPTMCM, 0, 48, 1, 0)
	AddSliderEx("$PosesHaloPoserWeaponMCM", CATEGORY_POSES, CALLBACK_POSE_HALOHPWMCM, 0, 81, 1, 0)
	
	;;Aloe
	AddSliderEx("$PosesAloe", CATEGORY_POSES, CALLBACK_POSE_ALOE, 0, 81, 1, 0)
		
	;;Kinoko
	AddSliderEx("$PosesKinoko", CATEGORY_POSES, CALLBACK_POSE_KINOKO, 0, 81, 1, 0)
	
	;;Goma
	AddSliderEx("$PosesGoma", CATEGORY_POSES, CALLBACK_POSE_GOMAPEROPERO, 0, 324, 1, 0)
		
	;;Lamir
	AddSliderEx("$PosesLamir", CATEGORY_POSES, CALLBACK_POSE_LAMIR, 0, 40, 1, 0)
	
	;;EIS Brainsperm
	AddSliderEx("$PosesBrainsperm1", CATEGORY_POSES, CALLBACK_POSE_BRAINSPERM1, 0, 81, 1, 0)
	AddSliderEx("$PosesBrainsperm2", CATEGORY_POSES, CALLBACK_POSE_BRAINSPERM2, 0, 81, 1, 0)
	AddSliderEx("$PosesBrainsperm3", CATEGORY_POSES, CALLBACK_POSE_BRAINSPERM3, 0, 81, 1, 0)
	AddSliderEx("$PosesBrainsperm4", CATEGORY_POSES, CALLBACK_POSE_BRAINSPERM4, 0, 81, 1, 0)

	;;EIS Oden
	AddSliderEx("$PosesOden1", CATEGORY_POSES, CALLBACK_POSE_ODEN1, 0, 81, 1, 0)
	AddSliderEx("$PosesOden2", CATEGORY_POSES, CALLBACK_POSE_ODEN2, 0, 81, 1, 0)
	AddSliderEx("$PosesOden3", CATEGORY_POSES, CALLBACK_POSE_ODEN3, 0, 81, 1, 0)

	;;Shocky
	AddSliderEx("$PosesShocky1", CATEGORY_POSES, CALLBACK_POSE_SHOCKY1, 0, 81, 1, 0)
	AddSliderEx("$PosesShocky2", CATEGORY_POSES, CALLBACK_POSE_SHOCKY2, 0, 47, 1, 0)	
EndEvent

Event OnSliderChanged(string callback, float value)
	If _versionValid
		If value == 0.0 && (callback == CALLBACK_POSE_DEFAULT || callback == CALLBACK_POSE_FNISSPC || callback == CALLBACK_POSE_FNISSPA || callback == CALLBACK_POSE_FNISSPO || callback == CALLBACK_POSE_FNISSPB || callback == CALLBACK_POSE_ALOE || callback == CALLBACK_POSE_KINOKO || callback == CALLBACK_POSE_GOMAPEROPERO || callback == CALLBACK_POSE_LAMIR || callback == CALLBACK_POSE_SAM || callback == CALLBACK_POSE_HALOHPCOMCM || callback == CALLBACK_POSE_HALOHPCTMCM || callback == CALLBACK_POSE_HALOHPCTRMCM || callback == CALLBACK_POSE_HALOHPEXMCM || callback == CALLBACK_POSE_HALOHPOMCM || callback == CALLBACK_POSE_HALOHPPMCM || callback == CALLBACK_POSE_HALOHPSMCM || callback == CALLBACK_POSE_HALOHPTMCM || callback == CALLBACK_POSE_HALOHPWMCM || callback == CALLBACK_POSE_PINUPACTIONMCM || callback == CALLBACK_POSE_PINUPKNEELMCM || callback == CALLBACK_POSE_PINUPLAYMCM || callback == CALLBACK_POSE_PINUPMANMCM || callback == CALLBACK_POSE_PINUPOTHERMCM || callback == CALLBACK_POSE_PINUPPAIRMCM || callback == CALLBACK_POSE_PINUPSITMCM || callback == CALLBACK_POSE_PINUPSTANDMCM || callback == CALLBACK_POSE_BRAINSPERM1 || callback == CALLBACK_POSE_BRAINSPERM2 || callback == CALLBACK_POSE_BRAINSPERM3 || callback == CALLBACK_POSE_BRAINSPERM4 || callback == CALLBACK_POSE_ODEN1 || callback == CALLBACK_POSE_ODEN2 || callback == CALLBACK_POSE_ODEN3 || callback == CALLBACK_POSE_SHOCKY1 || callback == CALLBACK_POSE_SHOCKY2 || callback == CALLBACK_POSE_PINUPACTION || callback == CALLBACK_POSE_HALOPOSER || callback == CALLBACK_POSE_HALOPOSERTREESOME || callback == CALLBACK_POSE_HALOPOSEREXT || callback == CALLBACK_POSE_HALOPOSERPAIR || callback == CALLBACK_POSE_HALOPOSERPAIR2 || callback == CALLBACK_POSE_HALOPOSERPAIR3 || callback == CALLBACK_POSE_HALOPOSERSILLY || callback == CALLBACK_POSE_HALOPOSEROBJECT || callback == CALLBACK_POSE_PINUPDPOSER || callback == CALLBACK_POSE_PINUPPAIR || callback == CALLBACK_POSE_PINUPSTAND || callback == CALLBACK_POSE_PINUPKNEEL || callback == CALLBACK_POSE_PINUPLAY || callback == CALLBACK_POSE_PINUPSIT || callback == CALLBACK_POSE_PINUPEX || callback == CALLBACK_POSE_PINUPMAN || callback == CALLBACK_POSE_SNSD || callback == CALLBACK_POSE_PUBLICPOSER1 || callback == CALLBACK_POSE_PUBLICPOSER2 || callback == CALLBACK_POSE_PUBLICPOSER3 || callback == CALLBACK_POSE_PUBLICPOSER4 || callback == CALLBACK_POSE_PUBLICPOSER5)
			Debug.SendAnimationEvent(_targetActor, "IdleForceDefaultState")
		Else
			If callback == CALLBACK_POSE_DEFAULT
				If value == -1
					Debug.SendAnimationEvent(_targetActor, "IdleStaticPoseaStart")
				Endif
			Elseif callback == CALLBACK_POSE_FNISSPC
				PlayPoseNumber(_targetActor, POSE_FNISSPC, value)
			Elseif callback == CALLBACK_POSE_FNISSPA
				PlayPoseNumber(_targetActor, POSE_FNISSPA, value)
			Elseif callback == CALLBACK_POSE_FNISSPO
				PlayPoseNumber(_targetActor, POSE_FNISSPO, value)
			Elseif callback == CALLBACK_POSE_FNISSPB
				PlayPoseNumber(_targetActor, POSE_FNISSPB, value)
			Elseif callback == CALLBACK_POSE_ALOE
				PlayPoseNumber(_targetActor, POSE_ALOE, value)
			Elseif callback == CALLBACK_POSE_KINOKO
				If value < 10
					PlayPoseNumber(_targetActor, POSE_KINOKO + "0", value)
				Else 
					PlayPoseNumber(_targetActor, POSE_KINOKO + "", value)
				Endif
			Elseif callback == CALLBACK_POSE_GOMAPEROPERO
				If value <= 81
					PlayPoseNumber(_targetActor, POSE_GOMAPEROPERO1, value)
				ElseIf value <= 162
					PlayPoseNumber(_targetActor, POSE_GOMAPEROPERO2, (value - 81))
				ElseIf value <= 243
					PlayPoseNumber(_targetActor, POSE_GOMAPEROPERO3, (value - 162))
				Else
					PlayPoseNumber(_targetActor, POSE_GOMAPEROPERO4, (value - 243))
				Endif
			Elseif callback == CALLBACK_POSE_LAMIR
				PlayPoseNumber(_targetActor, POSE_LAMIR, value)
			Elseif callback == CALLBACK_POSE_SAM
				If value < 10
					PlayPoseNumber(_targetActor, POSE_SAM + "0", value)
				Else 
					PlayPoseNumber(_targetActor, POSE_SAM + "", value)
				Endif
			Elseif callback == CALLBACK_POSE_HALOHPCOMCM
				PlayPoseNumber(_targetActor, POSE_HALOHPCOMCM, value)
			Elseif callback == CALLBACK_POSE_HALOHPCTMCM
				PlayPoseNumber(_targetActor, POSE_HALOHPCTMCM, value)
			Elseif callback == CALLBACK_POSE_HALOHPCTRMCM
				PlayPoseNumber(_targetActor, POSE_HALOHPCTRMCM, value)
			Elseif callback == CALLBACK_POSE_HALOHPEXMCM
				PlayPoseNumber(_targetActor, POSE_HALOHPEXMCM, value)
			Elseif callback == CALLBACK_POSE_HALOHPOMCM
				PlayPoseNumber(_targetActor, POSE_HALOHPOMCM, value)	
			Elseif callback == CALLBACK_POSE_HALOHPPMCM
				PlayPoseNumber(_targetActor, POSE_HALOHPPMCM, value)
			Elseif callback == CALLBACK_POSE_HALOHPSMCM
				PlayPoseNumber(_targetActor, POSE_HALOHPSMCM, value)
			Elseif callback == CALLBACK_POSE_HALOHPTMCM
				PlayPoseNumber(_targetActor, POSE_HALOHPTMCM, value)
			Elseif callback == CALLBACK_POSE_HALOHPWMCM
				PlayPoseNumber(_targetActor, POSE_HALOHPWMCM, value)
			Elseif callback == CALLBACK_POSE_PINUPACTIONMCM
				PlayPoseNumber(_targetActor, POSE_PINUPACTIONMCM, value)
			Elseif callback == CALLBACK_POSE_PINUPKNEELMCM
				PlayPoseNumber(_targetActor, POSE_PINUPKNEELMCM, value)
			Elseif callback == CALLBACK_POSE_PINUPLAYMCM
				PlayPoseNumber(_targetActor, POSE_PINUPLAYMCM, value)
			Elseif callback == CALLBACK_POSE_PINUPMANMCM
				PlayPoseNumber(_targetActor, POSE_PINUPMANMCM, value)
			Elseif callback == CALLBACK_POSE_PINUPOTHERMCM
				PlayPoseNumber(_targetActor, POSE_PINUPOTHERMCM, value)
			Elseif callback == CALLBACK_POSE_PINUPPAIRMCM
				PlayPoseNumber(_targetActor, POSE_PINUPPAIRMCM, value)
			Elseif callback == CALLBACK_POSE_PINUPSITMCM
				PlayPoseNumber(_targetActor, POSE_PINUPSITMCM, value)
			Elseif callback == CALLBACK_POSE_PINUPSTANDMCM
				PlayPoseNumber(_targetActor, POSE_PINUPSTANDMCM, value)
			Elseif callback == CALLBACK_POSE_BRAINSPERM1
				If value < 10
					PlayPoseNumber(_targetActor, POSE_BRAINSPERM1 + "00", value)
				Else 
					PlayPoseNumber(_targetActor, POSE_BRAINSPERM1 + "0", value)
				Endif
			Elseif callback == CALLBACK_POSE_BRAINSPERM2
				If value < 10
					PlayPoseNumber(_targetActor, POSE_BRAINSPERM2 + "00", value)
				Else 
					PlayPoseNumber(_targetActor, POSE_BRAINSPERM2 + "0", value)
				Endif
			Elseif callback == CALLBACK_POSE_BRAINSPERM3
				If value < 10
					PlayPoseNumber(_targetActor, POSE_BRAINSPERM3 + "00", value)
				Else 
					PlayPoseNumber(_targetActor, POSE_BRAINSPERM3 + "0", value)
				Endif
			Elseif callback == CALLBACK_POSE_BRAINSPERM4
				If value < 10
					PlayPoseNumber(_targetActor, POSE_BRAINSPERM4 + "00", value)
				Else 
					PlayPoseNumber(_targetActor, POSE_BRAINSPERM4 + "0", value)
				Endif
			Elseif callback == CALLBACK_POSE_ODEN1
				If value < 10
					PlayPoseNumber(_targetActor, POSE_ODEN1 + "00", value)
				Else 
					PlayPoseNumber(_targetActor, POSE_ODEN1 + "0", value)
				Endif
			Elseif callback == CALLBACK_POSE_ODEN2
				If value < 10
					PlayPoseNumber(_targetActor, POSE_ODEN2 + "00", value)
				Else 
					PlayPoseNumber(_targetActor, POSE_ODEN2 + "0", value)
				Endif
			Elseif callback == CALLBACK_POSE_ODEN3
				If value < 10
					PlayPoseNumber(_targetActor, POSE_ODEN3 + "00", value)
				Else 
					PlayPoseNumber(_targetActor, POSE_ODEN3 + "0", value)
				Endif
			Elseif callback == CALLBACK_POSE_SHOCKY1
				If value < 10
					PlayPoseNumber(_targetActor, POSE_SHOCKY1 + "00", value)
				Else 
					PlayPoseNumber(_targetActor, POSE_SHOCKY1 + "0", value)
				Endif
			Elseif callback == CALLBACK_POSE_SHOCKY2
				If value == 1
					PlayPoseNumber(_targetActor, POSE_SHOCKY2 + "15m_" + "00", value)
				ElseIf value == 2
					PlayPoseNumber(_targetActor, POSE_SHOCKY2 + "15f_" + "00", value)
				ElseIf value == 3
					PlayPoseNumber(_targetActor, POSE_SHOCKY2 + "14m_" + "00", value)
				ElseIf value == 4
					PlayPoseNumber(_targetActor, POSE_SHOCKY2 + "14f_" + "00", value)
				ElseIf value == 5
					PlayPoseNumber(_targetActor, POSE_SHOCKY2 + "13m_" + "00", value)
				ElseIf value == 6
					PlayPoseNumber(_targetActor, POSE_SHOCKY2 + "13f_" + "00", value)
				ElseIf value == 7
					PlayPoseNumber(_targetActor, POSE_SHOCKY2 + "12m_" + "00", value)
				ElseIf value == 8
					PlayPoseNumber(_targetActor, POSE_SHOCKY2 + "12f_" + "00", value)
				ElseIf value == 9
					PlayPoseNumber(_targetActor, POSE_SHOCKY2 + "11m" + "00", value)
				ElseIf value == 10
					PlayPoseNumber(_targetActor, POSE_SHOCKY2 + "11f" + "0", value)
				ElseIf value == 11
					PlayPoseNumber(_targetActor, POSE_SHOCKY2 + "10m" + "0", value)
				ElseIf value == 12
					PlayPoseNumber(_targetActor, POSE_SHOCKY2 + "10f" + "0", value)
				ElseIf value == 13
					PlayPoseNumber(_targetActor, POSE_SHOCKY2 + "9m" + "0", value)
				ElseIf value == 14
					PlayPoseNumber(_targetActor, POSE_SHOCKY2 + "9f" + "0", value)
				ElseIf value == 15
					PlayPoseNumber(_targetActor, POSE_SHOCKY2 + "8m" + "0", value)
				ElseIf value == 16
					PlayPoseNumber(_targetActor, POSE_SHOCKY2 + "8f" + "0", value)
				ElseIf value == 17
					PlayPoseNumber(_targetActor, POSE_SHOCKY2 + "7m" + "0", value)
				ElseIf value == 18
					PlayPoseNumber(_targetActor, POSE_SHOCKY2 + "7f" + "0", value)
				ElseIf value == 19
					PlayPoseNumber(_targetActor, POSE_SHOCKY2 + "6m" + "0", value)
				ElseIf value == 20
					PlayPoseNumber(_targetActor, POSE_SHOCKY2 + "6f" + "0", value)
				ElseIf value == 21
					PlayPoseNumber(_targetActor, POSE_SHOCKY2 + "5m" + "0", value)
				ElseIf value == 22
					PlayPoseNumber(_targetActor, POSE_SHOCKY2 + "5f" + "0", value)
				ElseIf value == 23
					PlayPoseNumber(_targetActor, POSE_SHOCKY2 + "4m" + "0", value)
				ElseIf value == 24
					PlayPoseNumber(_targetActor, POSE_SHOCKY2 + "4f" + "0", value)
				ElseIf value == 25
					PlayPoseNumber(_targetActor, POSE_SHOCKY2 + "3m" + "0", value)
				ElseIf value == 26
					PlayPoseNumber(_targetActor, POSE_SHOCKY2 + "3f" + "0", value)
				ElseIf value == 27
					PlayPoseNumber(_targetActor, POSE_SHOCKY2 + "2m" + "0", value)
				ElseIf value == 28
					PlayPoseNumber(_targetActor, POSE_SHOCKY2 + "2f" + "0", value)
				ElseIf value == 29
					PlayPoseNumber(_targetActor, POSE_SHOCKY2 + "1m" + "0", value)
				ElseIf value == 30
					PlayPoseNumber(_targetActor, POSE_SHOCKY2 + "1f" + "0", value)
				ElseIf value == 31
					PlayPoseNumber(_targetActor, POSE_SHOCKY2MISC + "11m" + "0", value)
				ElseIf value == 32
					PlayPoseNumber(_targetActor, POSE_SHOCKY2MISC + "11f" + "0", value)
				ElseIf value == 33
					PlayPoseNumber(_targetActor, POSE_SHOCKY2MISC + "10f" + "0", value)
				ElseIf value == 34
					PlayPoseNumber(_targetActor, POSE_SHOCKY2MISC + "9m" + "0", value)
				ElseIf value == 35
					PlayPoseNumber(_targetActor, POSE_SHOCKY2MISC + "9f" + "0", value)
				ElseIf value == 36
					PlayPoseNumber(_targetActor, POSE_SHOCKY2MISC + "8f" + "0", value)
				ElseIf value == 37
					PlayPoseNumber(_targetActor, POSE_SHOCKY2MISC + "7m" + "0", value)
				ElseIf value == 38
					PlayPoseNumber(_targetActor, POSE_SHOCKY2MISC + "7f" + "0", value)
				ElseIf value == 39
					PlayPoseNumber(_targetActor, POSE_SHOCKY2MISC + "6m" + "0", value)
				ElseIf value == 40
					PlayPoseNumber(_targetActor, POSE_SHOCKY2MISC + "6f" + "0", value)
				ElseIf value == 41
					PlayPoseNumber(_targetActor, POSE_SHOCKY2MISC + "5f" + "0", value)
				ElseIf value == 42
					PlayPoseNumber(_targetActor, POSE_SHOCKY2MISC + "4f" + "0", value)
				ElseIf value == 43
					PlayPoseNumber(_targetActor, POSE_SHOCKY2MISC + "3f" + "0", value)
				ElseIf value == 44
					PlayPoseNumber(_targetActor, POSE_SHOCKY2MISC + "2m" + "0", value)
				ElseIf value == 45
					PlayPoseNumber(_targetActor, POSE_SHOCKY2MISC + "2f" + "0", value)
				ElseIf value == 46
					PlayPoseNumber(_targetActor, POSE_SHOCKY2MISC + "1m" + "0", value)					
				Else 
					PlayPoseNumber(_targetActor, POSE_SHOCKY2MISC + "1f" + "0", value)
				Endif
			Elseif callback == CALLBACK_POSE_PINUPACTION
				If value <= 18
					PlayPoseNumber(_targetActor, POSE_PINUPACTION1HSWORD, value)
				ElseIf value <= 36
					PlayPoseNumber(_targetActor, POSE_PINUPACTIONFIST, (value - 18))
				ElseIf value <= 54
					PlayPoseNumber(_targetActor, POSE_PINUPACTIONZWEI, (value - 36))
				ElseIf value <= 72
					PlayPoseNumber(_targetActor, POSE_PINUPACTIONDUAL, (value - 54))
				ElseIf value <= 77
					PlayPoseNumber(_targetActor, POSE_PINUPACTIONBOW, (value - 72))
				Else 
					PlayPoseNumber(_targetActor, POSE_PINUPACTIONCBOW, (value - 77))
				Endif
			Elseif callback == CALLBACK_POSE_HALOPOSER
				If value <= 81
					PlayPoseNumber(_targetActor, POSE_HALOPOSER, value)
				ElseIf value <= 162
					PlayPoseNumber(_targetActor, POSE_HALOPOSER2, (value - 81))
				ElseIf value <= 243
					PlayPoseNumber(_targetActor, POSE_HALOPOSER3, (value - 162))
				ElseIf value <= 324
					PlayPoseNumber(_targetActor, POSE_HALOPOSER4, (value - 243))
				ElseIf value <= 405
					PlayPoseNumber(_targetActor, POSE_HALOPOSER5, (value - 324))
				ElseIf value <= 486
					PlayPoseNumber(_targetActor, POSE_HALOPOSER6, (value - 405))
				ElseIf value <= 567
					PlayPoseNumber(_targetActor, POSE_HALOPOSER7, (value - 486))
				ElseIf value <= 648
					PlayPoseNumber(_targetActor, POSE_HALOPOSER8, (value - 567))
				ElseIf value <= 729
					PlayPoseNumber(_targetActor, POSE_HALOPOSER9, (value - 648))	
				ElseIf value <= 810
					PlayPoseNumber(_targetActor, POSE_HALOPOSER10, (value - 729))
				ElseIf value <= 891
					PlayPoseNumber(_targetActor, POSE_HALOPOSER11, (value - 810))
				ElseIf value <= 972
					PlayPoseNumber(_targetActor, POSE_HALOPOSER12, (value - 891))
				ElseIf value <= 1053
					PlayPoseNumber(_targetActor, POSE_HALOPOSER13, (value - 972))
				ElseIf value <= 1134
					PlayPoseNumber(_targetActor, POSE_HALOPOSER14, (value - 1053))
				ElseIf value <= 1215
					PlayPoseNumber(_targetActor, POSE_HALOPOSER15, (value - 1134))
				EndIf
			ElseIf callback == CALLBACK_POSE_HALOPOSERTREESOME
				if modulo(value as int, 3) == 0
					PlayPoseNumber(_targetActor, POSE_HALOPOSERTREESOME, Math.Ceiling((value / 3)), "c" )
				ElseIf modulo(value as int, 3) == 1
					PlayPoseNumber(_targetActor, POSE_HALOPOSERTREESOME, Math.Ceiling((value / 3)), "a" )
				Else
					PlayPoseNumber(_targetActor, POSE_HALOPOSERTREESOME, Math.Ceiling((value / 3)), "b" )
				EndIf
			ElseIf callback == CALLBACK_POSE_HALOPOSEREXT
				PlayPoseNumber(_targetActor, POSE_HALOPOSEREXT, value)
			ElseIf callback == CALLBACK_POSE_HALOPOSERPAIR
				if modulo(value as int, 2) == 0
					PlayPoseNumber(_targetActor, POSE_HALOPOSERPAIR, Math.Ceiling((value / 2)), "b" )
				Else
					PlayPoseNumber(_targetActor, POSE_HALOPOSERPAIR, Math.Ceiling((value / 2)), "a" )
				EndIf
			ElseIf callback == CALLBACK_POSE_HALOPOSERPAIR2
				if modulo(value as int, 2) == 0
					PlayPoseNumber(_targetActor, POSE_HALOPOSERPAIR2, Math.Ceiling((value / 2)), "b" )
				Else
					PlayPoseNumber(_targetActor, POSE_HALOPOSERPAIR2, Math.Ceiling((value / 2)), "a" )
				EndIf
			ElseIf callback == CALLBACK_POSE_HALOPOSERPAIR3
				PlayPoseNumber(_targetActor, POSE_HALOPOSERPAIR3, value)
			ElseIf callback == CALLBACK_POSE_HALOPOSERSILLY
				PlayPoseNumber(_targetActor, POSE_HALOPOSERSILLY, value)
			ElseIf callback == CALLBACK_POSE_HALOPOSEROBJECT
				PlayPoseNumber(_targetActor, POSE_HALOPOSEROBJECT, value)
			Elseif callback == CALLBACK_POSE_PINUPDPOSER
				PlayPoseNumber(_targetActor, POSE_PINUPDPOSER, value)
			Elseif callback == CALLBACK_POSE_PINUPPAIR
				If modulo(value as int, 2) == 0
					PlayPoseNumber(_targetActor, POSE_PINUPPAIR, Math.Ceiling(value / 2), "b" )
				Else
					PlayPoseNumber(_targetActor, POSE_PINUPPAIR, Math.Ceiling(value / 2), "a" )
				EndIf
			Elseif callback == CALLBACK_POSE_PINUPSTAND
				If value <= 81
					PlayPoseNumber(_targetActor, POSE_PINUPSTAND, value)
				ElseIf value <= 162
					PlayPoseNumber(_targetActor, POSE_PINUPSTAND2, (value - 81))
				ElseIf value <= 243
					PlayPoseNumber(_targetActor, POSE_PINUPSTAND2, (value - 162))
				ElseIf value <= 261
					PlayPoseNumber(_targetActor, POSE_PINUPSTANDEX5, (value - 243))
				Else
					PlayPoseNumber(_targetActor, POSE_PINUPSTANDEX5W, (value - 261))
				Endif
			Elseif callback == CALLBACK_POSE_PINUPKNEEL
				If value <= 27
					PlayPoseNumber(_targetActor, POSE_PINUPKNEEL, value)
				ElseIf value <= 54
					PlayPoseNumber(_targetActor, POSE_PINUPKNEEL5, (value - 27))
				ElseIf value <= 63
					PlayPoseNumber(_targetActor, POSE_PINUPKNEELEX5, (value - 54))
				Else
					PlayPoseNumber(_targetActor, POSE_PINUPKNEELEX5W, (value - 63))
				Endif
			Elseif callback == CALLBACK_POSE_PINUPLAY
				If value <= 27
					PlayPoseNumber(_targetActor, POSE_PINUPLAY, value)
				ElseIf value <= 54
					PlayPoseNumber(_targetActor, POSE_PINUPLAY5, (value - 27))
				ElseIf value <= 63
					PlayPoseNumber(_targetActor, POSE_PINUPLAYEX5, (value - 54))
				Else
					PlayPoseNumber(_targetActor, POSE_PINUPLAYEX5W, (value - 63))
				Endif
			Elseif callback == CALLBACK_POSE_PINUPSIT
				If value <= 27
					PlayPoseNumber(_targetActor, POSE_PINUPSIT, value)
				ElseIf value <= 54
					PlayPoseNumber(_targetActor, POSE_PINUPSIT5, (value - 27))
				ElseIf value <= 63
					PlayPoseNumber(_targetActor, POSE_PINUPSITEX5, (value - 54))		
				Else
					PlayPoseNumber(_targetActor, POSE_PINUPSITEX5W, (value - 63))		
				Endif
			Elseif callback == CALLBACK_POSE_PINUPEX
				PlayPoseNumber(_targetActor, POSE_PINUPEX, value)
			Elseif callback == CALLBACK_POSE_PINUPMAN
				If value <= 54
					PlayPoseNumber(_targetActor, POSE_PINUPMANSTAND, value)
				ElseIf value <= 63
					PlayPoseNumber(_targetActor, POSE_PINUPMANSIT, (value - 54))
				ElseIf value <= 72
					PlayPoseNumber(_targetActor, POSE_PINUPMANLAY, (value - 63))		
				Else
					PlayPoseNumber(_targetActor, POSE_PINUPMANKNEEL, (value - 72))		
				Endif
			Elseif callback == CALLBACK_POSE_SNSD
				If value <= 9
					PlayPoseNumber(_targetActor, POSE_SNSDGEE, value)
				ElseIf value <= 18
					PlayPoseNumber(_targetActor, POSE_SNSDOH, (value - 9))
				ElseIf value <= 27
					PlayPoseNumber(_targetActor, POSE_SNSDRDR, (value - 18))		
				ElseIf value <= 36
					PlayPoseNumber(_targetActor, POSE_SNSDBG, (value - 27))		
				ElseIf value <= 45
					PlayPoseNumber(_targetActor, POSE_SNSDHOOT, (value - 36))		
				ElseIf value <= 54
					PlayPoseNumber(_targetActor, POSE_SNSDGENIE, (value - 45))		
				ElseIf value <= 63
					PlayPoseNumber(_targetActor, POSE_SNSDMT, (value - 54))		
				ElseIf value <= 72
					PlayPoseNumber(_targetActor, POSE_SNSDTB, (value - 63))	
				Else
					PlayPoseNumber(_targetActor, POSE_SNSDCONCERT, (value - 72))		
				Endif
			Elseif callback == CALLBACK_POSE_PUBLICPOSER1
				PlayPoseNumber(_targetActor, POSE_PUBLICPOSER1, value)
			Elseif callback == CALLBACK_POSE_PUBLICPOSER2
				PlayPoseNumber(_targetActor, POSE_PUBLICPOSER2, value)
			Elseif callback == CALLBACK_POSE_PUBLICPOSER3
				PlayPoseNumber(_targetActor, POSE_PUBLICPOSER3, value)
			Elseif callback == CALLBACK_POSE_PUBLICPOSER4
				PlayPoseNumber(_targetActor, POSE_PUBLICPOSER4, value)
			Elseif callback == CALLBACK_POSE_PUBLICPOSER5
				PlayPoseNumber(_targetActor, POSE_PUBLICPOSER5, value)
			Endif
		Endif
	Endif
EndEvent

Function PlayPoseNumber(Actor akActor, string animationName, float value, string animationSuffix = "")
	Debug.SendAnimationEvent(akActor, animationName + (value as int) + animationSuffix)
EndFunction

int Function modulo(int a, int m)
	;(a mod m) := a - m * (a div m);
	;(a div m) := sgn(a)*sgn(m)*floor(abs(a)/abs(m));
	return a - m * (signum(a) * signum(m) * Math.Floor(Math.abs(a) / Math.abs(m)))
EndFunction

int Function signum(float number)
	If number == 0.0
		return 0
	ElseIf number > 0.0
		return 1
	Else 
		return -1
	Endif
EndFunction